<?php

namespace Mainto\RpcServer\RpcUtil\Tool\Monitor\Driver;


use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\RpcUtil\Tool\Monitor\DriverInterface;
use Mainto\RpcServer\RpcUtil\Tool\RpcMonitorInterface;
use Throwable;

class Local implements DriverInterface {
    /**
     * @param array $contents
     */
    public function send (array $contents) {
        $content = sprintf("[%s] %s: %s\n", date('Y-m-d H:i:s'), config('rpc-server.service_name'), json_encode($contents, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
        @file_put_contents(storage_path("logs/rpc_monitor.log"), $content, FILE_APPEND);
    }
}