<?php


namespace Mainto\RpcServer\Providers\SqlTrace;


use Illuminate\Database\Connection;
use Illuminate\Support\ServiceProvider;

class SqlTraceProvider extends ServiceProvider {
    public function boot () {
    }

    public function register () {
        if (in_array(config('rpc-server.environment'), config('rpc-server.sql_trace.environments'))) {
            Connection::resolverFor('mysql', function ($connection, $database, $prefix, $config) {
                return new MysqlConnection($connection, $database, $prefix, $config);
            });
        }
    }
}
