<?php

namespace Mainto\RpcServer\RpcServer\ContextTrait;


use Mainto\RpcServer\RpcServer\RpcContext;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use Mainto\RpcServer\RpcServer\RpcParams;

trait ParamTrait {
    use RequestTrait;

    /**
     * 请求参数
     * @var RpcParams
     */
    private RpcParams $rpcParams;

    public ?array $parameters = null;

    public function resetParams() {
        $this->rpcParams->params = null;
        $this->rpcParams->_declareNames = [];
    }

    /**
     * 获得声明中的参数
     */
    public function onlyDeclare (): array {
        return $this->rpcParams->onlyDeclare();
    }

    /**
     * 获得指定key部分的子集
     *
     * @param array|mixed $keys
     * @return array
     */
    public function only (array $keys): array {
        return $this->rpcParams->only($keys);
    }

    /**
     * 从请求中获取全部信息
     *
     * @param array|mixed $keys
     * @return array
     */
    public function all ($keys = null): array {
        if (!$keys) {
            return $this->rpcParams->toArray();
        }

        return $this->rpcParams->only($keys);
    }

    /**
     * 获取参数输入
     *
     * @param null $key
     * @param null $default
     * @return mixed
     */
    public function input ($key = null, $default = null) {
        return $this->rpcParams->get($key, $default);
    }

    /**
     * 得到除了指定key之外的子集
     *
     * @param array|mixed $keys
     * @return array
     */
    public function except (array $keys): array {
        return $this->rpcParams->except($keys);
    }

    /**
     * 在已声明的参数里得到除了指定key之外的子集
     *
     * @param array|mixed $keys
     * @return array
     */
    public function declaredExcept (array $keys): array {
        return $this->rpcParams->declaredExcept($keys);
    }

    /**
     * 判断请求中是否存在
     *
     * @param $key
     * @return bool
     */
    public function has ($key): bool {
        return $this->rpcParams->has($key);
    }

    /**
     * @return RpcParams
     */
    public function getRpcParams (): RpcParams {
        return $this->rpcParams;
    }

    /**
     * @return array
     */
    public function getParams (): array {
        if ($this->rpcParams->params === null) {
            $this->rpcParams->params = $this->request->getAllParams();
        }

        return $this->rpcParams->params;
    }

    /**
     * @param array $params
     */
    public function setParams(array $params) {
        $this->rpcParams->params = $params;
    }

    /**
     * @return array|null
     * @throws \ReflectionException
     */
    public function getParameters(): array {
        if ($this->parameters === null) {
            $this->parameters = [];

            $params = $this->getParams();
            foreach ($this->getMethod()->getParameters() as $name => $parameter) {
                if ($parameter->type === RpcContext::class) {
                    $this->parameters[] = $this;
                } else {
                    if (class_exists($parameter->type)) {
                        $object = new $parameter->type;

                        RpcDefinition::getInstance()->getMapper()->map($params, $object);
                        $this->parameters[] = $object;
                    } else {
                        $this->parameters[] = $params[$name] ?? null;
                    }
                }
            }
        }

        return $this->parameters;
    }

    /**
     * @param array $declareNames
     */
    public function setDeclareNames(array $declareNames) {
        $this->rpcParams->_declareNames = $declareNames;
    }
}
