<?php


namespace Mainto\RpcServer\RpcAnnotations;


/**
 * Class RpcMessageHook
 * @package Mainto\RpcServer\RpcAnnotations
 *
 * @Annotation
 * @Target({"METHOD"})
 *
 * @Attributes({
 *     @Attribute("roomName", type = "string"),
 *     @Attribute("needConnectMessage", type="boolean"),
 *     @Attribute("needDisconnectMessage", type="boolean"),
 * })
 */
class RpcWebsocket {
    /**
     * 房间名称
     *
     * @Required
     * @var string
     */
    public string $roomName = "";

    /**
     * 是否订阅用户连接消息
     *
     * @var bool
     */
    public bool $needConnectMessage = false;

    /**
     * 是否订阅用户断开连接消息
     *
     * @var bool
     */
    public bool $needDisconnectMessage = false;
}