<?php


namespace Mainto\RpcServer\Util\ObjectMapper;


use Mainto\RpcServer\Util\Language;
use Mainto\RpcServer\Util\Types\Map;

class MapTypeParser {
    public static function parseMapReturn (array $useClasses, string $doc, string $namespace): array {
        if (!$doc) return ['Map', null];

        foreach (explode("\n", $doc) as $line) {
            if (str_contains($line, '@return')) {
                $match = [];
                $type = null;
                $keyType = 'string|int';
                if (preg_match('/.*@return\s*Map<(.*)>/', $line, $match) && count($match) > 1) {
                    $types = explode(',', $match[1]);
                    $type = trim(array_pop($types));
                    $keyType = trim(array_pop($types) ?: $keyType);
                }

                /*** @var Map $_ */
                if (preg_match('/.*@return\s*\\\Mainto\\\RpcServer\\\Util\\\Types\\\Map<(.*)>/', $line, $match) && count($match) > 1) {
                    $types = explode(',', $match[1]);
                    $type = trim(array_pop($types));
                    $keyType = trim(array_pop($types) ?: $keyType);
                }

                if ($type !== null) {
                    if (in_array($type, Language::$simpleType)) {
                        return ["Map<$keyType, $type>", $type];
                    }
                    if (isset($useClasses[$type])) {
                        return ["Map<$keyType, {$useClasses[$type]}>", $useClasses[$type]];
                    }

                    $type =  ltrim($type, '\\');
                    return [sprintf("Map<$keyType, %s>", $namespace.'\\'.$type), $namespace.'\\'.$type];
                }

                break;
            }
        }

        return ['Map', null];
    }

    public static function parseMapProperty(string $doc, array $useClasses, string $namespace): array {
        if (!$doc) return ['Map', null];

        foreach (explode("\n", $doc) as $line) {
            if (str_contains($line, '@var')) {
                $match = [];
                $type = null;
                $keyType = 'string|int';
                if (preg_match('/.*@var\s*Map<(.*)>/', $line, $match) && count($match) > 1) {
                    $types = explode(',', $match[1]);
                    $type = trim(array_pop($types));
                    $keyType = trim(array_pop($types) ?: $keyType);
                }

                /*** @var Map $_ */
                if (preg_match('/.*@var\s*\\\Mainto\\\RpcServer\\\Util\\\Types\\\Map<(.*)>/', $line, $match) && count($match) > 1) {
                    $types = explode(',', $match[1]);
                    $type = trim(array_pop($types));
                    $keyType = trim(array_pop($types) ?: $keyType);
                }

                if ($type !== null) {
                    if (in_array($type, Language::$simpleType)) {
                        return ["Map<$keyType, $type>", $type];
                    }
                    if (isset($useClasses[$type])) {
                        return ["Map<$keyType, {$useClasses[$type]}>", $useClasses[$type]];
                    }

                    return [sprintf("Map<$keyType, %s>", $namespace.'\\'.$type), $namespace.'\\'.$type];
                }

                break;
            }
        }

        return ['Map', null];
    }
}
