<?php


namespace Mainto\RpcServer\Protocol\Response;


use Mainto\RpcServer\Protocol\Response\Extend\ResponseExtendError;
use Mainto\RpcServer\Protocol\Response\Extend\ResponseExtendHeader;
use RuntimeException;

class ExtendFactory {
    public static array $extendMap = [
        Extend::MagicNumUrlInvoke => ResponseExtendHeader::class,
        Extend::MagicNumErrorExtend => ResponseExtendError::class
    ];

    public static function getManagedRequestExtendByMagicNum(int $magicNum): Extend {
        if (!isset(self::$extendMap[$magicNum])) {
            throw new RuntimeException("magic is not support");
        }

        $class = self::$extendMap[$magicNum];

        return new $class();
    }
}