<?php


namespace Mainto\RpcServer\Base;


use Exception;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use RuntimeException;

/**
 * Class RpcMessage
 * @package Mainto\RpcServer\Base
 */
abstract class RpcMessage {
    public string $_uuid_;

    public function __construct () {
        $this->_uuid_ = $this->mustGetUuid4()->toString();
    }

    /**
     * 不能包含字符 ' " < > & : |
     *
     * @return string
     */
    abstract public static function messageName(): string;

    private function mustGetUuid4 (): UuidInterface {
        try {
            return Uuid::uuid4();
        } catch (Exception $e) {
            throw new RuntimeException($e->getCode(), $e->getMessage());
        }
    }
}