<?php


namespace Mainto\RpcServer\RpcClient;


use WeakReference;

class RpcClientWeakRef {

    /**
     * [method, args]
     * @var array
     */
    protected array $createClientOption = [];

    /**
     * Rpc 客户端 Ref
     * @var WeakReference
     */
    protected WeakReference $clientWeakRef;

    public function __construct (array $createClientOption) {
        $this->createClientOption = $createClientOption;

        $this->clientWeakRef = WeakReference::create(RpcClientFactory::getClient($this->createClientOption[0], array_slice($this->createClientOption, 1)));
    }

    /**
     * @return RpcClient
     */
    public function getClient(): RpcClient {
        $client = $this->clientWeakRef->get();
        if ($client == null) {
            $client = RpcClientFactory::getClient($this->createClientOption[0], array_slice($this->createClientOption, 1));
            $this->clientWeakRef = WeakReference::create($client);
        }

        return $client;
    }

    public function clearClient() {
        $client = $this->clientWeakRef->get();
        if ($client) {
            RpcClientFactory::clearClient($client);
        }
    }
}