<?php


namespace Mainto\RpcServer\RpcServer\Definition;


use Illuminate\Contracts\Support\Arrayable;
use Mainto\RpcServer\Util\ArrayHelper;
use Mainto\RpcServer\Util\ObjectMapper\PropertyRef;

class Property extends PropertyRef implements Arrayable {
    use ArrayHelper;
    /**
     * @var string
     */
    public string $name;

    /**
     * @var string
     */
    public string $type;

    /**
     * @var string
     */
    public string $comment = "";

    /**
     * @var mixed|null
     */
    public $example = null;

    /**
     * @var string
     */
    public string $validation = "";

    /**
     * @var bool
     */
    public bool $require = false;

    /**
     * 默认值, 判断是否真正设置了默认值 需使用 defaultValueAvailable
     *
     * @var mixed|null
     */
    public $default = null;

    /**
     * @var bool
     */
    public bool $defaultValueAvailable = false;

    /**
     * @var bool
     */
    public bool $nullable = false;

    /**
     * @var string
     */
    public string $setterMethod = "";

    private ?string $_validation = null;

    /**
     * @var string
     */
    public string $fromSession = "";

    /**
     * @var string
     */
    public string $fromHeader = "";

    /**
     * @return string
     */
    public function getValidation (): string {
        if ($this->_validation === null) {
            $this->_validation = $this->validation;

            if ($this->require) {
                if (!$this->_validation) {
                    $this->_validation = "required";
                } elseif (strpos($this->_validation, "required") === false) {
                    $this->_validation .= "|required";
                }
            }
            if ($this->nullable) {
                if (!$this->_validation) {
                    $this->_validation = "nullable";
                } elseif (strpos($this->_validation, "nullable") === false) {
                    $this->_validation = 'nullable|' . $this->_validation;
                }
            }
        }

        return $this->_validation;
    }
}