<?php


namespace Mainto\RpcServer\RpcServer\Definition\Traits;


use Illuminate\Support\Str;
use Mainto\RpcServer\Exceptions\RpcRuntimeException;
use Mainto\RpcServer\RpcServer\Definition\Struct;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use Mainto\RpcServer\Util\Language;

trait ValidateGetter {
    private ?array $validationRules = null;

    public static function validateArray ($type, $data) {
        if (ends_with($type, '[]')) {
            $subType = substr($type, 0, -2);
            foreach ($data as $key => $item) {
                self::validateArray($subType, $item);
            }
        } else {
            if (in_array($type, Language::$rpcSimpleType) || $type == 'mixed') {
                return;
            }
            self::validateByStruct(RpcDefinition::getInstance()->getStruct($type), $data);
        }
    }

    public static function validateByStruct (Struct $struct, $params) {
        $validationRules = [];
        foreach ($struct->getProperties() as $property) {
            if (Str::endsWith($property->type, '[]') || RpcDefinition::getInstance()->inStructCache($property->type)) {
                if (!array_key_exists($property->name, $params) && !$property->require) continue;

                if (array_key_exists($property->name, $params) && $params[$property->name] === null) {
                    if (!$property->nullable) {
                        throw new RpcRuntimeException("key `{$property->name}` is not a {$property->type} instance", 422);
                    } else {
                        continue;
                    }
                }

                RpcDefinition::getInstance()->inStructCache($property->type)
                    ? self::validateByStruct(RpcDefinition::getInstance()->getStruct($property->type), $params[$property->name])
                    : self::validateArray($property->type, $params[$property->name]);
            } else {
                $validationRules[$property->name] = $property->getValidation();
            }
        }

        validator($params, $validationRules)->validate();
    }

    /**
     * @param array $params
     * @return void
     */
    public function validate (array $params): void {
        self::validateByStruct($this, $params);
    }
}