<?php


namespace Mainto\RpcServer\RpcServer;


use Closure;
use ReflectionException;

class RpcInvoke {
    /**
     * @var array ['methodName' => ['middleware' => '', 'args' => []]]
     */
    protected static array $methodMiddlewaresMap = [];

    /**
     * @var array|null ['methodName' => 'callback']
     */
    protected static ?array $methodInvokerMap = null;

    public static function addMethodMiddleware (string $fullMethodName, $middleware) {
        self::$methodMiddlewaresMap[$fullMethodName][] = $middleware;
    }

    public static function init() {
        self::initMethodInvoker();
    }

    /**
     * @param RpcContext $context
     * @return mixed
     */
    public static function invokeThroughMiddleware (RpcContext $context) {
        $method = $context->getRequest()->getCallClassName().'::'.$context->getRequest()->getCallMethodName();

        if (isset(self::$methodInvokerMap[$method])) {
            return (self::$methodInvokerMap[$method])($context);
        }

        return self::invokeBase($context);
    }

    protected static function initMethodInvoker () {
        foreach (self::$methodMiddlewaresMap as $fullMethodName => $middlewares) {
            self::$methodInvokerMap[$fullMethodName] = array_reduce(
                array_reverse($middlewares),
                fn(Closure $next, $middle) => fn(RpcContext $context) => $middle->handle($context, $next),
                function (RpcContext $context) {
                    return self::invokeBase($context);
                },
            );
        }
    }

    /**
     * @param RpcContext $context
     * @return mixed
     */
    public static function invokeBase (RpcContext $context) {
        $rpcParams = new RpcParams($context->getParams());
        $method = $context->getMethod();
        $context->setDeclareNames($method->getRequestDeclareNames());

        $rpcParams->_declareNames = $method->getRequestDeclareNames();

        try {
            return $method->getRefInstance()->invokeArgs($context->getController()->getInstance(), $method->buildMethodParams($context, $context->getParams()));
        } catch (ReflectionException $exception) {
            throw new \RuntimeException($exception->getMessage());
        }
    }
}