<?php

namespace Mainto\RpcServer\RpcServer;

use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\RpcServer\ContextTrait\HeaderTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\ParamTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\RequestTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\RpcMessageTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\SessionTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\UrlTrait;

class RpcContext {
    use ParamTrait;
    use HeaderTrait;
    use SessionTrait;
    use RpcMessageTrait;
    use RequestTrait;
    use UrlTrait;

    /**
     * @deprecated
     * @var string
     */
    public static string $currentTraceId = "";

    private static ?RpcContext $currentContext = null;

    public function __construct () {
        self::$currentContext = $this;
        $this->rpcParams = new RpcParams();
    }

    /**
     * @return RpcContext|null
     */
    public static function getCurrentContext (): ?RpcContext {
        return self::$currentContext;
    }

    public static function getCurrentTraceId (): string {
        if (self::$currentContext) {
            return self::$currentContext->request->getTraceId();
        }

        return "";
    }

    public static function getCurrentSessionId (): ?string {
        if (self::$currentContext) {
            return self::$currentContext->getSessionId();
        }

        return null;
    }

    public function reset (Request $request): RpcContext {
        $this->request = $request;

        self::$currentTraceId = $this->request->getTraceId();

        $this->resetSession();
        $this->resetHeader();
        $this->resetParams();

        return $this;
    }

    /**
     * @return string
     */
    public function getRequestFrom (): string {
        return $this->getRequestHeaders()['X-Request-From'] ?? 'unknown';
    }
}