<?php


namespace Mainto\RpcServer\RpcServer\Middleware\Method;


use Closure;
use Mainto\RpcServer\RpcServer\Middleware\MethodMiddleware;
use Mainto\RpcServer\RpcServer\RpcContext;

class SessionMiddleware implements MethodMiddleware {

    private function __construct () { }

    private static ?SessionMiddleware $instance = null;

    public static function getInstance (): ?SessionMiddleware {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function handle (RpcContext $context, Closure $next) {
        $res = $next($context);

        $context->saveSession();

        return $res;
    }
}