<?php


namespace Mainto\RpcServer\RpcServer\Middleware;


use Closure;
use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\Protocol\Common\Types\RequestHeaderType;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\RpcStreamContext;

class StopMiddleware implements Middleware {
    public function handle (RpcStreamContext $context, Closure $next): Response {
        if ($context->request->getType() == RequestHeaderType::SidecarStopType) {
            Log::debug("exit by recv SidecarStopType signal", ['streamId' => $context->streamId, 'pid' => $context->pid]);
            $context->stop();

            $response = new Response();
            $response->useReturnOKType();
            return $response;
        }

        return $next($context);
    }
}