<?php


namespace Mainto\RpcServer\RpcServer\Middleware;


use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\Log\LogHandler;
use Mainto\RpcServer\Protocol\Common\Body;
use Mainto\RpcServer\Protocol\Common\Types\RequestHeaderType;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\Kernel;
use Mainto\RpcServer\RpcServer\RpcStreamContext;
use Mainto\RpcServer\Util\Net\Net;
use Mainto\RpcServer\Util\OS;
use RuntimeException;
use Throwable;

class ForkMiddleware implements Middleware {
    /**
     * @var Response
     */
    private Response $cacheResponse;

    public function __construct () {
        $this->cacheResponse = new Response();
    }

    public function handle (RpcStreamContext $context, \Closure $next): Response {
        if ($context->request->getType() == RequestHeaderType::SidecarScaleUpType) {
            $unixAddress = collect($context->request->getBody()->getContent())->get("unix");
            $childId = pcntl_fork();
            if ($childId < 0) {
                throw new RuntimeException("fork fail");
            } elseif ($childId == 0) {
                try {
                    LogHandler::init(storage_path("logs/service/".now()->format("Y-m-d")), pathinfo($unixAddress, PATHINFO_FILENAME));

                    Log::info("worker start and serve", ['pid' => getmypid(), 'unix' => $unixAddress]);

                    //                    $this->close();
                    OS::setProcessTitle(sprintf("rpc-php [%s] [%s] child", config('rpc-server.service_name'), $unixAddress));

                    $seed = intval(time() + (microtime(true) * 1000));
                    mt_srand($seed);

                    app(Kernel::class, [
                        'conn'     => Net::dialTimeout("unix", $unixAddress, 3),
                        'streamId' => $unixAddress,
                    ])->run();
                } catch (Throwable $exception) {
                    Log::warning("child exit by error", ['error' => $exception->getMessage()]);
                } finally {
                    exit(0);
                }
            }

            $this->cacheResponse->useReturnOKType();
            $this->cacheResponse->setBody(Body::newJsonBody(json_encode(["pid" => $childId])));
            return $this->cacheResponse;
        }

        return $next($context);
    }
}