<?php


namespace Mainto\RpcServer\RpcServer\Middleware;


use Closure;
use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\Log\LogHandler;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\RpcStreamContext;

class DebugMiddleware implements Middleware {
    private bool $dumpEnable = false;

    public function __construct () {
        if (config('logging.channels')[config('logging.default')]['handler'] == LogHandler::class) {
            if (config('logging.channels')[config('logging.default')]['with']['level'] == "debug") {
                $this->dumpEnable = true;
            }
        }
    }

    public function handle (RpcStreamContext $context, Closure $next): Response {
        if ($this->dumpEnable) {
            Log::debug("server recv req", ['pid' => $context->pid, 'traceId' => $context->request->getTraceId(), 'data' => $context->request->toArray()]);
        }

        $response = $next($context);

        if ($this->dumpEnable) {
            Log::debug("server send req", ['pid' => $context->pid, 'traceId' => $context->request->getTraceId(), 'data' => $response->toArray()]);
        }

        return $response;
    }
}