<?php


namespace Mainto\RpcServer\RpcServer\Middleware;


use Mainto\RpcServer\Protocol\Common\Body;
use Mainto\RpcServer\Protocol\Common\Types\RequestHeaderType;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\RpcStreamContext;
use Mainto\RpcServer\RpcServer\RpcRouter;

class ConfigMiddleware implements Middleware {
    public function handle (RpcStreamContext $context, \Closure $next): Response {
        if ($context->request->getType() == RequestHeaderType::SidecarConfigType) {
            return self::serviceConfigResponse();
        }

        return $next($context);
    }

    public static function serviceConfigResponse (): Response {
        $response = new Response();
        $response->useReturnOKType();

        $body = Body::newJsonBody(json_encode(RpcRouter::getInstance()->getBaseRouterConfig()));
        $response->setBody($body);

        return $response;
    }
}