<?php


namespace Mainto\RpcServer\RpcServer\Middleware;


use Closure;
use Mainto\RpcServer\Protocol\Common\Types\RequestHeaderType;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\RpcStreamContext;

class CheckMiddleware implements Middleware {
    /**
     * @var Response
     */
    private Response $checkOKResponse;

    public function __construct () {
        $this->checkOKResponse = new Response();
        $this->checkOKResponse->useReturnOKType();
    }

    public function handle (RpcStreamContext $context, Closure $next): Response {
        if ($context->request->getType() == RequestHeaderType::SystemCheckType) {
            return $this->checkOKResponse;
        }

        return $next($context);
    }
}