<?php


namespace Mainto\RpcServer\RpcServer;


use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\Middleware\CheckMiddleware;
use Mainto\RpcServer\RpcServer\Middleware\ConfigMiddleware;
use Mainto\RpcServer\RpcServer\Middleware\DebugMiddleware;
use Mainto\RpcServer\RpcServer\Middleware\ForkMiddleware;
use Mainto\RpcServer\RpcServer\Middleware\StopMiddleware;
use Mainto\RpcServer\Util\Net\Conn;

class MasterKernel extends Kernel {
    public function __construct (Conn $conn, string $streamId) {
        parent::__construct($conn, $streamId);

        app('events')->listen('rpc.framework.kernel.starting', function () {
            pcntl_signal(SIGCHLD, SIG_IGN);
            event('rpc.framework.kernel.master.starting');
        });
    }

    protected function initMiddleware () {
        $this->middlewares = [
            new StopMiddleware(),
            new DebugMiddleware(),
            new ConfigMiddleware(),
            new CheckMiddleware(),
            new ForkMiddleware(),
        ];
    }

    protected function invoke (RpcStreamContext $context): Response {


        // master 不处理调用
        return $this->cacheErrResponse;
    }
}