<?php


namespace Mainto\RpcServer\RpcServer\Definition\Traits;


use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;
use Mainto\RpcServer\RpcServer\Definition\Property;
use Mainto\RpcServer\RpcServer\RpcDefinition;

trait ValidateGetter {
    private ?array $validationRules = null;

    /**
     * @param array $params
     * @throws ValidationException
     */
    public function validate (array $params): void {
        $validator = Validator::make($params, $this->getValidationRules(), [], []);

        if ($validator->fails()) {
            throw new ValidationException($validator);
        }
    }

    public function getValidationRules (): array {
        if ($this->validationRules === null) {
            $this->validationRules = [];

            /** @var Property $property */
            foreach ($this->properties as $property) {
                $this->validationRules[$property->name] = $property->getValidation();

                if (Str::endsWith($property->type, '[]')) {
                    foreach (RpcDefinition::getInstance()->getStruct(substr($property->type, 0, -2))->getValidationRules() as $name => $validation) {
                        $this->validationRules[$property->name.'.*.'.$name] = $validation;
                    }

                } elseif (RpcDefinition::getInstance()->inStructCache($property->type)) {
                    foreach (RpcDefinition::getInstance()->getStruct($property->type)->getValidationRules() as $name => $validation) {
                        $this->validationRules[$property->name.'.'.$name] = $validation;
                    }
                }
            }
        }

        return $this->validationRules;
    }
}