<?php


namespace Mainto\RpcServer\RpcServer\Middleware;


use Illuminate\Database\MySqlConnection;
use Illuminate\Support\Facades\DB;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\RpcStreamContext;

class RecoverMiddleware implements Middleware {
    public function handle (RpcStreamContext $context, \Closure $next): Response {
        try {
            return $next($context);
        } finally {
            $this->resourceRecover();
        }
    }

    /**
     * 回收可能导致有问题的资源
     */
    private function resourceRecover () {
        foreach (DB::getConnections() as $connection) {
            if ($connection instanceof MySqlConnection) {
                while ($connection->transactionLevel()) {
                    $connection->rollBack();
                }
            }
        }
    }
}