<?php


namespace Mainto\RpcServer\RpcServer\Middleware;


use Closure;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\RpcStreamContext;

class MethodMiddleware implements Middleware {
    /**
     * @var array ['methodName' => ['middleware' => '', 'args' => []]]
     */
    protected static array $methodMiddlewaresMap = [

    ];

    /**
     * @var array ['methodName' => 'callback']
     */
    protected static array $methodPipeMap = [

    ];

    public static function addMethodMiddleware (string $fullMethodName, $middleware, array $args) {
        self::$methodMiddlewaresMap[$fullMethodName][] = [
            'middleware' => $middleware,
            'args'       => $args,
        ];
    }

    public function __construct () {
        foreach (self::$methodMiddlewaresMap as $name => $middlewareItem) {
            ['middleware' => $middleware, 'args' => $args] = $middlewareItem;
            self::$methodPipeMap[$name] = array_reduce(
                array_reverse($this->$middleware),
                fn(Closure $next, $middle) => fn(RpcStreamContext $context) => $middle->handle($context, $args, $next),
                fn(RpcStreamContext $context, Closure $next) => $next($context)
            );
        }
    }

    public function handle (RpcStreamContext $context, Closure $next): Response {
        $method = $context->request->getCallClassName().'::'.$context->request->getCallMethodName();

        if (isset(self::$methodMiddlewaresMap[$method])) {
            return (self::$methodMiddlewaresMap[$method])($context, $next);
        }

        return $next($context);
    }
}