<?php

namespace Mainto\RpcServer\RpcUtil\Tool\Monitor\Driver;

use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\RpcClient\RpcClient;
use Mainto\RpcServer\Protocol\Common\Body;
use Mainto\RpcServer\Protocol\Common\Types\RequestHeaderType;
use Mainto\RpcServer\Protocol\Common\Types\ResponseHeaderType;
use Mainto\RpcServer\Protocol\Request\Extend\RequestExtendHeader;
use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\Protocol\Response\Extend\ResponseExtendError;
use Mainto\RpcServer\RpcClient\RpcClientFactory;
use Mainto\RpcServer\RpcClient\RpcClientWeakRef;
use Mainto\RpcServer\RpcServer\RpcContext;
use Mainto\RpcServer\RpcUtil\Tool\Monitor\DriverInterface;
use RuntimeException;
use Throwable;

class SidecarPrometheus implements DriverInterface {
    private static ?Request $cacheRequest = null;

    /**
     * @var RpcClientWeakRef
     */
    private RpcClientWeakRef $clientRef;

    public function __construct () {
        if (self::$cacheRequest === null) {
            $requestExtendHeader = new RequestExtendHeader();
            self::$cacheRequest = new Request();
            self::$cacheRequest->setType(RequestHeaderType::SidecarMonitorType);
            self::$cacheRequest->setExtend($requestExtendHeader);

            $this->clientRef = new RpcClientWeakRef([RpcClientFactory::MonitorClient]);
        }
    }

    /**
     * @return RpcClient
     */
    protected function getClient(): RpcClient {
        return $this->clientRef->getClient();
    }

    public function clearClient() {
        $this->clientRef->clearClient();
    }

    /**
     * send message to sidecar sls service
     *
     * @param $source
     * @param $logStore
     * @param $contents
     */
    public function send (array $contents) {
        try {
            /** @var RequestExtendHeader $ext */
            $ext = self::$cacheRequest->getExt();
            $contents['service_name'] = config('rpc-server.service_name');
            self::$cacheRequest->setBody(Body::newJsonBody(json_encode($contents)));

            self::$cacheRequest->setTraceId(RpcContext::$currentTraceId);
            $response = $this->getClient()->Do(self::$cacheRequest);
            switch ($response->getType()) {
                case ResponseHeaderType::ReturnOKType:
                    break;
                case ResponseHeaderType::ReturnSystemErrType:
                case ResponseHeaderType::ReturnErrType:
                    $extend = $response->getExt();
                    if ($extend instanceof ResponseExtendError) {
                        throw new RuntimeException($extend->getErrMsg(), $extend->getErrorCode());
                    }

                    throw new RuntimeException("unknown response ext");
                default:
                    throw new RuntimeException("unknown response");
            }
        } catch (Throwable $e) {
            $this->clearClient();
            Log::error($e, $contents);
            throw new RuntimeException("can not find this monitor server", 0, $e);
        }
    }


}
