<?php


namespace Mainto\RpcServer\RpcServer\Definition\Traits;


use Illuminate\Support\Str;
use Mainto\RpcServer\Exceptions\RpcRuntimeException;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use Mainto\RpcServer\Util\Language;
use Mainto\RpcServer\Util\ObjectMapper\PropertiesInterface;

trait ValidateGetter {
    private ?array $validationRules = null;

    public static function validateArray($type, $data) {
        if (ends_with($type, '[]')) {
            $subType = substr($type, 0, -2);
            foreach ($data as $key => $item) {
                self::validateArray($subType, $item);
            }
        } else {
            if (in_array($type, Language::$rpcSimpleType) || $type == 'mixed') {
                return;
            }
            self::validateByStruct(RpcDefinition::getInstance()->getStruct($type), $data);
        }
    }

    public static function validateByStruct(PropertiesInterface $struct, $params) {
        $validationRules = [];
        foreach ($struct->getProperties() as $property) {
            if (Str::endsWith($property->type, '[]')) {
                if (!isset($params[$property->name])) {
                    if ($property->defaultValueAvailable) continue;
                    if (!$property->nullable) {
                        throw new RpcRuntimeException("key `{$property->name}` is not a {$property->type} instance", 422);
                    }
                } else {
                    self::validateArray($property->type, $params[$property->name]);
                }
            } elseif (RpcDefinition::getInstance()->inStructCache($property->type)) {
                if (!isset($params[$property->name]) && $property->nullable) continue;

                if (!isset($params[$property->name]) && !$property->nullable) {
                    throw new RpcRuntimeException("key `{$property->name}` is not a {$property->type} instance", 422);
                }

                self::validateByStruct(RpcDefinition::getInstance()->getStruct($property->type), $params[$property->name]);
            } else {
                $validationRules[$property->name] = $property->getValidation();
            }
        }

        validator($params, $validationRules)->validate();
    }

    /**
     * @param array $params
     * @return void
     */
    public function validate (array $params): void {
        self::validateByStruct($this, $params);
    }
}