<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-12-23
 * Time: 下午4:43
 */

namespace Mainto\RpcServer\Command;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\Log\LogHandler;
use Mainto\RpcServer\RpcServer\MasterKernel;
use Mainto\RpcServer\Util\Net\Net;

class RpcServerCommand extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:server {--unix=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Server Command';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws \Throwable
     */
    public function handle () {
        $unix = $this->option('unix');

        LogHandler::init(storage_path("logs/service/".now()->format("Y-m-d")), 'master');

        Log::info("master start and serve", ['pid' => getmypid(), 'unix' => $unix]);

        (new MasterKernel(Net::dialTimeout("unix", $unix, 3), $unix))->run();
    }
}
