<?php


namespace Mainto\RpcServer\Service\Struct;


use Illuminate\Contracts\Support\Arrayable;

class MessageQueue implements Arrayable {
    use BaseStruct;

    private string $messageQueueHookName = "";

    /**
     * @param string $messageQueueHookName
     */
    public function setMessageQueueHookName (string $messageQueueHookName): void {
        $this->messageQueueHookName = $messageQueueHookName;
    }

    public function isEmpty (): bool {
        return $this->messageQueueHookName === "";
    }

    public function toArray () {
        return [
            'class'             => $this->class,
            'method'            => $this->method,
            'message_queue_hook_name' => $this->messageQueueHookName,
        ];
    }
}