<?php

namespace Mainto\RpcServer\RpcServer;

use Mainto\RpcServer\Protocol\Request\Extend\RequestExtendHeader;
use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\RpcServer\ContextTrait\HeaderTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\ParamTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\RequestTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\RpcMessageTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\SessionTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\UrlTrait;

class RpcContext {
    use ParamTrait;
    use HeaderTrait;
    use SessionTrait;
    use RpcMessageTrait;
    use RequestTrait;
    use UrlTrait;

    /**
     * @deprecated
     * @var string
     */
    public static string $currentTraceId = "";

    private static ?RpcContext $currentContext = null;

    /**
     * @param Request $request
     * @param RpcParams $params
     */
    public function __construct (Request $request, RpcParams $params) {
        $this->rpcParams = $params;
        $this->request = $request;

        $this->requestHeaders = $request->getAllHeaders();
        self::$currentTraceId = $this->request->getTraceId();
        $this->session_id = $this->getSessionId();

        self::$currentContext = $this;
    }

    /**
     * @return RpcContext|null
     */
    public static function getCurrentContext (): ?RpcContext {
        return self::$currentContext;
    }

    public static function getCurrentTraceId(): string {
        if (self::$currentContext) {
            return self::$currentContext->request->getTraceId();
        }

        return "";
    }

    public static function getCurrentSessionId(): ?string {
        if (self::$currentContext) {
            return self::$currentContext->getSessionId();
        }

        return null;
    }

    /**
     * @return string
     */
    public function getRequestFrom(): string {
        return $this->requestHeaders['X-Request-From'] ?? 'unknown';
    }
}