<?php

namespace Mainto\RpcServer\RpcServer\ContextTrait;


use Mainto\RpcServer\RpcServer\RpcParams;

trait ParamTrait {
    /**
     * 请求参数
     * @var RpcParams
     */
    private RpcParams $rpcParams;

    /**
     * 获得声明中的参数
     */
    public function onlyDeclare (): array {
        return $this->rpcParams->onlyDeclare();
    }

    /**
     * 获得指定key部分的子集
     *
     * @param array|mixed $keys
     * @return array
     */
    public function only ($keys): array {
        return $this->rpcParams->only($keys);
    }

    /**
     * 从请求中获取全部信息
     *
     * @param array|mixed $keys
     * @return array
     */
    public function all ($keys = null) {
        if (!$keys) {
            return $this->rpcParams->toArray();
        }

        return $this->rpcParams->only($keys);
    }

    /**
     * 获取参数输入
     *
     * @param null $key
     * @param null $default
     * @return mixed
     */
    public function input ($key = null, $default = null) {
        return $this->rpcParams->get($key, $default);
    }

    /**
     * 设置参数输入
     *
     * @param null $key
     * @param $value
     * @return mixed
     * @deprecated
     */
    public function setInput ($key, $value) {
        return $this->rpcParams->set($key, $value);
    }

    /**
     * 得到除了指定key之外的子集
     *
     * @param array|mixed $keys
     * @return array
     */
    public function except ($keys) {
        return $this->rpcParams->except($keys);
    }

    /**
     * 在已声明的参数里得到除了指定key之外的子集
     *
     * @param array|mixed $keys
     * @return array
     */
    public function declaredExcept (array $keys): array {
        return $this->rpcParams->declaredExcept($keys);
    }

    /**
     * 判断请求中是否存在
     *
     * @param $key
     * @return bool
     */
    public function has ($key) {
        return $this->rpcParams->has($key);
    }

    /**
     * @return RpcParams
     */
    public function getRpcParams (): RpcParams {
        return $this->rpcParams;
    }

}
