<?php

use Illuminate\Contracts\Support\Arrayable;

if (!function_exists('must_get_namespace')) {
    function must_get_namespace ($file) {
        $namespace = null;

        if (preg_match('#^namespace\s+(.+?);$#sm', file_get_contents($file), $m)) {
            $namespace = $m[1];
        }
        if (!$namespace) {
            throw new RuntimeException(sprintf("get namespace fail from %s", $file));
        }

        return $namespace;
    }
}

if (!function_exists('get_doc')) {
    function get_doc(string $fullDoc) {
        $doc = '';
        foreach (explode("\n", $fullDoc) as $line) {
            if (strpos($line, '@') === false && strpos($line, '/') === false) {
                $_doc = trim(str_replace('*', '', $line));
                if (!$_doc) continue;
                $doc .= $_doc."\n";
                continue;
            }
        }

        return trim($doc);
    }
}


if (!function_exists('rpc_gateway_url')) {
    /**
     * @param $environment
     * @return bool|mixed|string
     */
    function rpc_gateway_url($environment) {
        switch ($environment) {
            case 'stable':
                return 'https://api-gateway.hzmantu.com';
            case 'dev':
                return 'https://api.dev.hzmantu.com';
            case 'pre':
                return 'https://api.pre.hzmantu.com';
            case 'release':
                return 'https://api.release.hzmantu.com';
        }

        return 'http://localhost:3080';
    }
}

if (!function_exists('rpc_environment')) {
    /**
     * @param $hostname
     * @return bool|mixed|string
     */
    function rpc_environment($hostname) {
        $hostnameArr = explode('-', $hostname);
        if (count($hostnameArr) >= 3) {
            $tag = $hostnameArr[count($hostnameArr) - 3];
            switch ($tag) {
                case 'stable':
                    return 'stable';
                case 'pre':
                    return 'pre';
                case 'dev':
                    return 'dev';
                case 'release':
                    return 'release';
            }
        }

        return 'local';
    }
}

if (!function_exists('path_join')) {
    function path_join (...$args) {
        $path = "";
        foreach ($args as $arg) {
            if (!$arg) continue;

            $path .= $path ? (DIRECTORY_SEPARATOR.trim($arg, DIRECTORY_SEPARATOR)) : rtrim($arg, DIRECTORY_SEPARATOR);
        }

        return $path;
    }
}

if (!function_exists('remove_all')) {
    function remove_all ($dir) {
        $files = array_diff(scandir($dir), ['.', '..']);
        foreach ($files as $file) {
            (is_dir("$dir/$file")) ? remove_all("$dir/$file") : unlink("$dir/$file");
        }
        return rmdir($dir);
    }
}

if (!function_exists('rpc_exception_trace')) {
    function rpc_exception_trace(Throwable $throwable): string {
        $traceStr = "\n";
        foreach (explode("\n", $throwable->getTraceAsString()) as $key => $value) {
            $traceStr .= $value."\n";
            if (strpos($value, 'php-rpc-framework/src/RpcServer/RpcInvoke.php') !== false
                && strpos($value, 'ReflectionMethod->invokeArgs()') !== false) {
                $traceStr .= "[framework trace]";
                break;
            }
        }

        return $traceStr;
    }
}


if (!function_exists('get_object_public_vars')) {
    function get_object_public_vars ($object): array {
        return get_object_vars($object);
    }
}

if (!function_exists('to_array')) {
    function to_array (array $var): array {
        return array_map(function ($value) {
            if ($value instanceof Arrayable) {
                return $value->toArray();
            } elseif (is_array($value)) {
                return to_array($value);
            } else {
                return $value;
            }
        }, $var);
    }
}

if (!function_exists('to_array_map')) {
    function to_array_map (array $var): array {
        return array_map_with_Key(function ($value, $key) {
            if ($value instanceof Arrayable) {
                return [$key => $value->toArray()];
            } elseif (is_array($value)) {
                return [$key => to_array_map($value)];
            } else {
                return [$key => $value];
            }
        }, $var);
    }
}

if (!function_exists('array_map_with_Key')) {
    function array_map_with_Key(callable $callback, array $var): array {
        $map = [];
        foreach ($var as $key => $value) {
            $map += $callback($value, $key);
        }

        return $map;
    }
}

if (!function_exists('get_files')) {
    /**
     * Get files
     * @param $dir
     * @return array
     */
    function get_files ($dir) {
        $files = [];
        $scan = scandir($dir);
        foreach ($scan as $item) {
            if ($item == '.' || $item == '..') continue;
            if (is_dir($dir.'/'.$item)) {
                $files = array_merge($files, get_files($dir.'/'.$item));
            } else {
                $files[] = $dir.'/'.$item;
            }
        }
        return $files;
    }
}

if (!function_exists('get_git_branch_version')) {
    /**
     * Format the relative path as an absolute path with the current working directory as the reference
     *
     * @param string $base_path
     * @return string
     */
    function get_git_branch_version ($base_path = "") {
        if (!$version = env('CI_COMMIT_REF_SLUG')) {

            $git_file = $base_path ? $base_path.'/.git/HEAD' : base_path('/.git/HEAD');

            if (!file_exists($git_file)) {
                throw new \RuntimeException('get version fail');
            }

            $version = trim(str_replace(['ref: refs/heads/'], '', file_get_contents($git_file)));
            if (!$version) throw new \RuntimeException('get version fail');
        }
        return $version;
    }
}