<?php


namespace Mainto\RpcServer\RpcServer\Definition;

use Illuminate\Contracts\Support\Arrayable;
use Mainto\RpcServer\Util\ArrayHelper;
use Mainto\RpcServer\Util\Types\Map;

/**
 * Class Controller
 * @package Mainto\RpcServer\RpcServer\Definition
 */
class Controller implements Arrayable {
    use ArrayHelper;

    /**
     * @var string $name
     */
    public string $name;

    /**
     * @var string $shortName rtrim Controller
     */
    public string $shortName;

    /**
     * @var string
     */
    public string $namespace;
    /**
     * @var string
     */
    public string $alias = "";

    /**
     * @var Map<Method>|Method[]
     */
    public Map $methods;

    /**
     * @var object
     */
    private object $instance;

    public function __construct (object $instance) {
        $this->instance = $instance;
        $this->methods = new Map();
    }

    /**
     * @return object
     */
    public function getInstance (): object {
        return $this->instance;
    }
}