<?php


namespace Mainto\RpcServer\Util\Types;


use ArrayAccess;
use Exception;
use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Contracts\Support\Jsonable;
use JsonSerializable;

/**
 * Class Map
 * @package Mainto\RpcServer\Util\Types
 */
class Map implements Arrayable, Jsonable, ArrayAccess, JsonSerializable {
    /**
     * @var array
     */
    private array $item = [];

    public function set ($key, $value) {
        $this->item[$key] = $value;
    }

    public function get ($key) {
        return $this->item[$key] ?? null;
    }

    public function toArray (): array {
        return to_array($this->item);
    }

    public function toJson ($options = 0) {
        if ($this->item) {
            return json_encode($this->item, $options);
        } else {
            return '{}';
        }
    }

    public function jsonSerialize () {
        if ($this->item) {
            return $this->item;
        } else {
            return $this;
        }
    }

    public function offsetExists ($offset): bool {
        return array_key_exists($offset, $this->item);
    }

    /**
     * @param mixed $offset
     * @return mixed
     * @throws Exception
     */
    public function offsetGet ($offset) {
        if (array_key_exists($offset, $this->item)) {
            return $this->item[$offset];
        }

        throw new Exception("Undefined offset: $offset");
    }

    public function offsetSet ($offset, $value) {
        $this->item[$offset] = $value;
    }

    public function offsetUnset ($offset) {
        unset($this->item[$offset]);
    }
}