<?php


namespace Mainto\RpcServer\RpcUtil\Tool;


interface RpcMonitorInterface {

    /**
     * set
     *
     * @param string $name
     * @param float $value
     */
    public function set (string $name, float $value);

    /**
     * add
     *
     * @param string $name
     * @param float $value
     */
    public function add (string $name, float $value);

    /**
     * sub
     *
     * @param string $name
     * @param float $value
     */
    public function sub (string $name, float $value);

    /**
     * inc
     *
     * @param string $name
     */
    public function inc (string $name);

    /**
     * dec
     *
     * @param string $name
     */
    public function dec (string $name);

    /**
     * summary
     *
     * @param string $name
     * @param float $value
     */
    public function summary (string $name, float $value);
}