<?php


namespace Mainto\RpcServer\RpcAnnotations;


/**
 * Class RpcMiddleware
 * @package Mainto\RpcServer\RpcAnnotations
 *
 * @Annotation
 * @Target({"METHOD"})
 *
 * @Attributes({
 *     @Attribute("class", type = "string"),
 *     @Attribute("args", type = "array"),
 * })
 */
class RpcMiddleware {
    /**
     * Middleware class
     *
     * @Required
     * @var string
     */
    public string $class;

    /**
     * 额外参数
     *
     * @var array
     */
    public array $args = [];
}