<?php


namespace Mainto\RpcServer\Util\IO;


class Buffer implements Reader, Writer {
    private ReadBuffer $r;
    private WriteBuffer $w;

    public function __construct (ReadWriter $rw, $readBufSize = 4096, $writeBufSize = 4096) {
        $this->r = new ReadBuffer($rw, $readBufSize);
        $this->w = new WriteBuffer($rw, $writeBufSize);
    }

    public function read (int $size): ?string {
        return $this->r->read($size);
    }

    public function write (string $p): int {
        return $this->w->write($p);
    }

    public function flush() {
        $this->w->flush();
    }
}