<?php


namespace Mainto\RpcServer\Util;


use Illuminate\Contracts\Support\Arrayable;

/**
 * add toArray() for public property
 * Trait ArrayHelper
 * @package Mainto\RpcServer\Util
 */
trait ArrayHelper {
    public function toArray () {
        $ret = [];

        foreach (get_object_public_vars($this) as $key => $var) {
            if ($var instanceof Arrayable) {
                $ret[$key] = $var->toArray();
            } elseif (is_array($var)) {
                $arrayValueRet = [];
                foreach ($var as $arrayKey => $arrayValue) {
                    if ($arrayValue instanceof Arrayable) {
                        $arrayValueRet[$arrayKey] = $arrayValue->toArray();
                    } else {
                        $arrayValueRet[$arrayKey] = $arrayValue;
                    }
                }
                $ret[$key] = $arrayValueRet;
            } else {
                $ret[$key] = $var;
            }
        }

        return $ret;
    }
}