<?php

namespace Mainto\RpcServer\RpcServer;

use Mainto\RpcServer\Protocol\Request\Extend\RequestExtendHeader;
use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\RpcServer\ContextTrait\HeaderTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\ParamTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\RequestTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\RpcMessageTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\SessionTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\UrlTrait;

class RpcContext {
    use ParamTrait;
    use HeaderTrait;
    use SessionTrait;
    use RpcMessageTrait;
    use RequestTrait;
    use UrlTrait;

    /**
     * @deprecated
     * @var string
     */
    public static string $currentTraceId = "";

    /**
     * @param Request $request
     * @param RpcParams $params
     */
    public function __construct (Request $request, RpcParams $params) {
        $this->rpcParams = $params;
        $this->request = $request;

        $this->requestHeaders = $request->getAllHeaders();
        self::$currentTraceId = $this->request->getTraceId();
        $this->session_id = $this->getSessionId();
    }
}