<?php


namespace Mainto\RpcServer\RpcServer\ContextTrait;


use Mainto\RpcServer\Exceptions\RpcMethodNotFoundException;
use Mainto\RpcServer\Protocol\Common\Types\BodyType;
use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\RpcServer\Definition\Controller;
use Mainto\RpcServer\RpcServer\Definition\Method;
use Mainto\RpcServer\RpcServer\RpcDefinition;

trait RequestTrait {
    /**
     * @var Request
     */
    private Request $request;

    private ?Controller $controller = null;

    private ?Method $method = null;

    /**
     * @return Request
     */
    public function getRequest (): Request {
        return $this->request;
    }

    public function isRawMode (): bool {
        return optional($this->request->getBody())->getBodyType() == BodyType::RAW;
    }

    public function getMethod (): Method {
        if ($this->method == null) {
            $this->method = $this->getController()->methods->get($this->request->getCallMethodName());

            if (!$this->method) {
                throw new RpcMethodNotFoundException(sprintf("%s::%s", $this->request->getCallClassName(), $this->request->getCallMethodName()));
            }
        }
        return $this->method;
    }

    public function getController (): Controller {
        if ($this->controller == null) {
            $this->controller = RpcDefinition::getInstance()->controllers->get($this->request->getCallClassName());
            if (!$this->controller) {
                throw new RpcMethodNotFoundException(sprintf("%s::%s", $this->request->getCallClassName(), $this->request->getCallMethodName()));
            }
        }

        return $this->controller;
    }
}