<?php


namespace Mainto\RpcServer\Util\Types;


use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Contracts\Support\Jsonable;

class Map implements Arrayable, Jsonable {
    private array $item = [];

    public function set ($key, $value) {
        $this->item[$key] = $value;
    }

    public function get ($key) {
        return $this->item[$key] ?? null;
    }

    public function toArray () {
        return $this->item;
    }

    public function toJson ($options = 0) {
        if ($this->item) {
            return json_encode($this->item, $options);
        } else {
            return '{}';
        }
    }
}