<?php
namespace Mainto\RpcServer\Service\Struct;


use Illuminate\Contracts\Support\Arrayable;

class Message implements Arrayable {
    use BaseStruct;

    private string $messageHookName = "";

    /**
     * @param string $messageHookName
     */
    public function setMessageHookName (string $messageHookName): void {
        $this->messageHookName = $messageHookName;
    }

    public function isEmpty (): bool {
        return $this->messageHookName === "";
    }

    public function toArray () {
        return [
            'class'             => $this->class,
            'method'            => $this->method,
            'message_hook_name' => $this->messageHookName,
        ];
    }
}