<?php


namespace Mainto\RpcServer\RpcServer\Definition;


use Mainto\RpcServer\RpcAnnotations\RpcApi;
use Mainto\RpcServer\RpcAnnotations\RpcAuthority;
use Mainto\RpcServer\RpcAnnotations\RpcCron;
use Mainto\RpcServer\RpcAnnotations\RpcDisableTypeValidation;
use Mainto\RpcServer\RpcAnnotations\RpcFormat;
use Mainto\RpcServer\RpcAnnotations\RpcHeader;
use Mainto\RpcServer\RpcAnnotations\RpcMessageHook;
use Mainto\RpcServer\RpcAnnotations\RpcParam;
use Mainto\RpcServer\RpcAnnotations\RpcResponseHeader;
use Mainto\RpcServer\RpcAnnotations\RpcWebsocket;
use Mainto\RpcServer\RpcServer\RpcObject\NotDefinition;
use ReflectionMethod;

class Method {

    /**
     * @var string
     */
    public string $name;

    /**
     * @var string
     */
    public string $alias = "";

    /**
     * @var string
     */
    public string $description = "";

    /**
     * @var HttpApi|null
     */
    public ?HttpApi $httpApi = null;

    /**
     * @var Header[]
     */
    public array $headers = [];

    /**
     * @var object|null
     */
    public ?object $requestType = null;

    /**
     * @var object|null
     */
    public ?object $responseType;

    /**
     * @var string
     */
    public string $resFormat;

    /**
     * @var ResponseHeader[]
     */
    public array $resHeaders = [];

    /**
     * @var bool
     */
    public bool $checkValidation = true;

    /**
     * @var bool
     */
    public bool $checkType = true;

    /**
     * @var string
     */
    public string $authNeed;

    /**
     * @var string
     */
    public string $wsRoom;

    /**
     * @var string
     */
    public string $wsNeedConnectMessage;

    /**
     * @var string
     */
    public string $wsNeedDisconnectMessage;

    /**
     * @var string
     */
    public string $messageHookName;

    /**
     * @var string
     */
    public string $cronSpec;

    /**
     * @var string
     */
    public string $cronHookName;

    public ReflectionMethod $refInstance;

    public function loadFromRpcApi (RpcApi $rpcApi) {
        $url = $rpcApi->url;
        if ($rpcApi->addPrefix && config('rpc-server.url.enable_prefix')) {
            $url = path_join(config('rpc-server.url.prefix'), $url);
        }

        $this->httpApi = new HttpApi();
        $this->httpApi->method = $rpcApi->method;
        $this->httpApi->url = $url;
    }

    public function loadFromRpcHeader (RpcHeader $rpcHeader) {
        $header = new Header();
        $header->name = $rpcHeader->name;
        $this->headers[] = $header;
    }

    public function loadFromRpcFormat (RpcFormat $rpcFormat) {
        $this->resFormat = $rpcFormat->format;
    }

    public function loadFromRpcResponseHeader (RpcResponseHeader $rpcResponseHeader) {
        $header = new ResponseHeader();
        $header->name = $rpcResponseHeader->name;
        $header->value = $rpcResponseHeader->value;
        $this->resHeaders[] = $header;
    }

    public function loadFromRpcAuthority (RpcAuthority $rpcAuthority) {
        $this->authNeed = $rpcAuthority->need;
    }

    public function loadFromRpcMessageHook (RpcMessageHook $rpcMessageHook) {
        // 兼容旧websocket申明
        if (strpos($rpcMessageHook->name, "ws.") === 0) {
            print "\n###!!!!! RpcMessageHook ws.* for websocket is DEPRECATED and will be removed in a future version. Use RpcWebsocket instead.\n";
            $this->wsNeedConnectMessage = true;
            $this->wsNeedDisconnectMessage = true;
            $this->wsRoom = substr($rpcMessageHook->name, 3);
        } else {
            $this->messageHookName = $rpcMessageHook->name;
        }
    }

    public function loadFromRpcWebsocket (RpcWebsocket $annotation) {
        $this->wsNeedConnectMessage = $annotation->needConnectMessage;
        $this->wsNeedDisconnectMessage = $annotation->needDisconnectMessage;
        $this->wsRoom = $annotation->roomName;
    }

    public function loadFromRpcDisableTypeValidation (RpcDisableTypeValidation $annotation) {
        $this->checkType = $annotation->check_type;
        $this->checkValidation = $annotation->check_validation;
    }

    public function loadFromRpcCron (RpcCron $annotation, $classAliasName) {
        $annotation->every and $this->cronSpec = '@every '.$annotation->every;
        $annotation->entry and $this->cronSpec = '@'.$annotation->entry;
        $annotation->spec and $this->cronSpec = str_replace('\\', '/', $annotation->spec);

        $this->cronHookName = 'cron-'.snake_case(config('rpc-server.service_name')).'-'."{$classAliasName}::{$this->name}";
    }

    public function loadFromRpcParam (RpcParam $rpcParam) {
        if (!$this->requestType) {
            $this->requestType = new Struct();
            $this->requestType->name = class_basename(NotDefinition::class);
            $this->requestType->namespace = str_replace('NotDefinition', '', NotDefinition::class);
        }

        $property = new Property();
        $property->require = $rpcParam->require;
        $property->validation = $rpcParam->validation;
        $property->type = $rpcParam->type;
        $property->nullable = $rpcParam->nullable;
        $property->name = $rpcParam->name;

        if ($rpcParam->default !== null) {
            $property->default = $rpcParam->default;
        }
        $property->comment = $rpcParam->comment;

        $this->requestType->properties[] = $property;
    }
}