<?php


namespace Mainto\RpcServer\RpcServer\Definition;


use InvalidArgumentException;
use Mainto\RpcServer\Util\ObjectMapper\JsonMapper;
use Mainto\RpcServer\Util\ObjectMapper\MapperInterface;
use ReflectionClass;
use ReflectionException;
use ReflectionMethod;
use RuntimeException;

class Definition {
    private static ?MapperInterface $mapper = null;
    private static ?Definition $instance = null;
    /**
     * @var Controller[]
     */
    public array $controllers = [];
    /**
     * @var Struct[]
     */
    public array $structs = [];

    /**
     * @var array ['alias' => controller]
     */
    private array $controllerMap = [];

    /**
     * @var array ['controllerName' => 'aliasName']
     */
    private array $controllerAliasNameMap = [];

    private function __construct () { }

    public static function getInstance (): Definition {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function parse (string $path) {
        self::getMapper()->mapJsonArray(json_decode(file_get_contents($path), true), $this);
    }

    public static function getMapper () {
        if (self::$mapper === null) {
            self::$mapper = new JsonMapper();
        }

        return self::$mapper;
    }

    public function addClass (string $class, string $alias = null) {
        try {
            $refClass = new ReflectionClass($class);
            if (!$alias) {
                $alias = $refClass->getName();
                $pos = strrpos($alias, 'Controllers\\');
                if ($pos !== false) {
                    $alias = substr($alias, $pos + 12);
                } else {
                    throw new RuntimeException($class.' not has alias and path error');
                }
            }

            $this->addController($refClass, $alias);
        } catch (ReflectionException $e) {
            /** @var RuntimeException $e */
            throw $e;
        }
    }

    private function addController (ReflectionClass $refClass, string $alias) {
        if (isset($this->controllerMap[$alias]) && !$refClass->isInstance($this->controllerMap[$alias]->instance)) {
            throw new InvalidArgumentException(" duplicate class name/alias: {$alias}");
        }

        if (!ends_with($alias, 'Controller')) {
            throw new RuntimeException("class name must be use Controller end");
        }

        $controller = new Controller();
        $this->controllerMap[$alias] = $controller;
        $this->controllers[] = $controller;
        $this->controllerAliasNameMap[$alias] = $refClass->getName();

        $controller->alias = $alias;
        $controller->shortName = substr($alias, 0, -10);;
        $controller->name = $refClass->getName();
        $controller->instance = $refClass->newInstance();

        if (!($controller->instance instanceof \Mainto\RpcServer\Base\Controller)) {
            throw new RuntimeException("register router {$refClass->getName()} is not support");
        }

        $methods = $refClass->getMethods(ReflectionMethod::IS_PUBLIC);

        foreach ($methods as $method) {
            $controller->addMethod($method);
        }
    }
}