<?php


namespace Mainto\RpcServer\RpcServer\Definition;

use Doctrine\Common\Annotations\AnnotationReader;
use Mainto\RpcServer\RpcAnnotations\RpcApi;
use Mainto\RpcServer\RpcAnnotations\RpcAuthority;
use Mainto\RpcServer\RpcAnnotations\RpcCron;
use Mainto\RpcServer\RpcAnnotations\RpcDisableTypeValidation;
use Mainto\RpcServer\RpcAnnotations\RpcFormat;
use Mainto\RpcServer\RpcAnnotations\RpcHeader;
use Mainto\RpcServer\RpcAnnotations\RpcMessageHook;
use Mainto\RpcServer\RpcAnnotations\RpcParam;
use Mainto\RpcServer\RpcAnnotations\RpcResponseHeader;
use Mainto\RpcServer\RpcAnnotations\RpcWebsocket;
use ReflectionMethod;

/**
 * Class Controller
 * @package Mainto\RpcServer\RpcServer\Definition
 */
class Controller {

    /**
     * @var string $name
     */
    public string $name;

    /**
     * @var string $shortName
     */
    public string $shortName;

    /**
     * @var string
     */
    public string $namespace;
    /**
     * @var string
     */
    public string $alias = "";

    /**
     * @var Method[]
     */
    public array $methods;

    /**
     * @var object
     */
    public object $instance;

    public function addMethod (ReflectionMethod $refMethod) {
        $methodName = $refMethod->getShortName();
        if ($methodName[0] == "_") {
            return;
        }

        $this->methods[] = $method = new Method();
        $method->name = $methodName;
        $method->refInstance = $refMethod;

        $annotations = app(AnnotationReader::class)->getMethodAnnotations($refMethod);
        foreach ($annotations as $annotation) {
            if ($annotation instanceof RpcApi) {
                $method->loadFromRpcApi($annotation);
            } elseif ($annotation instanceof RpcHeader) {
                $method->loadFromRpcHeader($annotation);
            } elseif ($annotation instanceof RpcFormat) {
                $method->loadFromRpcFormat($annotation);
            } elseif ($annotation instanceof RpcResponseHeader) {
                $method->loadFromRpcResponseHeader($annotation);
            } elseif ($annotation instanceof RpcAuthority) {
                $method->loadFromRpcAuthority($annotation);
            } elseif ($annotation instanceof RpcMessageHook) {
                $method->loadFromRpcMessageHook($annotation);
            } elseif ($annotation instanceof RpcWebsocket) {
                $method->loadFromRpcWebsocket($annotation);
            } elseif ($annotation instanceof RpcDisableTypeValidation) {
                $method->loadFromRpcDisableTypeValidation($annotation);
            } elseif ($annotation instanceof RpcCron) {
                $method->loadFromRpcCron($annotation, $this->alias);
            } elseif ($annotation instanceof RpcParam) {
                $method->loadFromRpcParam($annotation);
            }
        }
    }
}