<?php


namespace Mainto\RpcServer\RpcServer\Definition;


use Illuminate\Contracts\Support\Arrayable;
use Mainto\RpcServer\RpcServer\Definition\Traits\ValidateGetter;
use Mainto\RpcServer\Util\ArrayHelper;

class Struct implements Arrayable, PropertiesInterface {
    use ArrayHelper, ValidateGetter;

    public string $name;
    public string $namespace;

    /**
     * @var Property[]
     */
    public array $properties = [];

    public function getProperties (): array {
        return $this->properties;
    }
}