<?php


namespace Mainto\RpcServer\RpcServer\Definition;


class Property {
    /**
     * @var string
     */
    public string $name;

    /**
     * @var string
     */
    public string $type;

    /**
     * @var string
     */
    public string $comment = "";

    /**
     * @var string
     */
    public string $validation = "";

    /**
     * @var bool
     */
    public bool $require = false;

    /**
     * @var mixed|null
     */
    public $default = null;

    /**
     * @var bool
     */
    public bool $nullable = false;

    /**
     * @var string
     */
    public string $setterMethod = "";

    private ?string $_validation = null;

    /**
     * @return string
     */
    public function getValidation (): string {
        if ($this->_validation === null) {
            $this->_validation = $this->validation;

            if ($this->require) {
                if (!$this->_validation) {
                    $this->_validation = "required";
                } elseif (strpos($this->_validation, "required") === false) {
                    $this->_validation .= "|required";
                }
            }
        }

        return $this->_validation;
    }
}