<?php


namespace Mainto\RpcServer\RpcServer\Definition\RpcObject;


use Mainto\RpcServer\RpcServer\Definition\Definition;
use Mainto\RpcServer\Util\ObjectMapper\MapperInterface;

/**
 * Class JsonMapper
 * @package Mainto\RpcServer\Util\ObjectMapper
 */
class JsonMapper implements MapperInterface {
    /**
     * @param $data
     * @param object $object
     */
    public function map ($data, object $object) {
        if (is_string($data)) {
            $data = json_decode($data, true);
        }

        $this->mapJsonArray($data, $object);
    }

    public function mapJsonArray (array $data, object $object) {
        foreach (ObjectRef::getRef($object)->properties as $propertyRef) {
            if (!array_key_exists($propertyRef->name, $data)) {
                continue;
            }

            $type = $propertyRef->type;
            if (in_array($type, Definition::SimpleTypes)) {
                $value = $data[$propertyRef->name];
            } else {
                if (ends_with($type, '[]')) {
                    $arrayValue = [];
                    $subType = substr($type, 0, -2);
                    foreach ($data[$propertyRef->name] as $datum) {
                        $subObject = new $subType;
                        $this->mapJsonArray($datum, $subObject);
                        $arrayValue[] = $subObject;
                    }

                    $value = $arrayValue;
                } else {
                    $propertyObject = new $type;
                    $this->mapJsonArray($data[$propertyRef->name], $propertyObject);

                    $value = $propertyObject;
                }
            }

            if ($propertyRef->setterMethod) {
                $object->{$propertyRef->setterMethod}($value);
            } else {
                $object->{$propertyRef->name} = $value;
            }
        }
    }
}