<?php


namespace Mainto\RpcServer\RpcServer\Definition;


use Mainto\RpcServer\RpcServer\Definition\RpcObject\ObjectRef;
use Mainto\RpcServer\Util\ObjectMapper\JsonMapper;
use Mainto\RpcServer\Util\ObjectMapper\MapperInterface;
use RuntimeException;

class Definition {
    private static ?MapperInterface $mapper = null;
    private static ?Definition $instance = null;
    /**
     * @var Controller[]
     */
    public array $controllers = [];

    /**
     * @var Struct[]
     */
    public array $structs = [];

    /**
     * @var array [typeName => Struct]
     */
    public static array $structMap = [];

    public const EmptyType = '#empty';

    public const SimpleTypes = [
        "string",
        "bool",
        "int",
        "uint",
        "double",
        "unsignedDouble",
        "array",
        "array<int>",
        "array<uint>",
        "array<string>",
    ];

    private function __construct () {
        $empty = new Struct();
        $empty->name = "EmptyStruct";
        $empty->namespace = "EmptyStruct";

        $this->structs[] = self::$structMap[self::EmptyType] = $empty;
    }

    public static function getInstance (): Definition {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public static function clear() {
        self::$instance = null;
        self::$structMap = [];
    }

    public static function inStructCache (string $type) {
        return isset(self::$structMap[$type]);
    }

    public static function getStruct(string $type): Struct {
        if (!isset(self::$structMap[$type])) {
            throw new RuntimeException("the struct not exists");
        }

        return self::$structMap[$type];
    }

    public static function objectStruct(string $type): Struct {
        if (!isset(self::$structMap[$type])) {
            self::getInstance()->structs[] = $struct = new Struct();

            $objectRef = ObjectRef::getRef($type);
            $struct->name = $objectRef->name;
            $struct->namespace = $objectRef->namespace;
            $struct->properties = $objectRef->properties;

            self::$structMap[$type] = $struct;
        }

        return self::$structMap[$type];
    }

    public static function notDefinitionStruct(string $type): Struct {
        if (!isset(self::$structMap[$type])) {
            self::getInstance()->structs[] = $struct = new Struct();

            $struct->name = $type;
            $struct->namespace = $type;

            self::$structMap[$type] = $struct;
        }

        return self::$structMap[$type];
    }

    public function parse (string $path) {
        self::getMapper()->mapJsonArray(json_decode(file_get_contents($path), true), $this);
    }

    public static function getMapper () {
        if (self::$mapper === null) {
            self::$mapper = new JsonMapper();
        }

        return self::$mapper;
    }
}