<?php


namespace Mainto\RpcServer\RpcServer\Definition;


use InvalidArgumentException;
use Mainto\RpcServer\Util\ObjectMapper\JsonMapper;
use Mainto\RpcServer\Util\ObjectMapper\MapperInterface;
use ReflectionClass;
use ReflectionException;
use ReflectionMethod;
use RuntimeException;

class Definition {
    private static ?MapperInterface $mapper = null;
    private static ?Definition $instance = null;
    /**
     * @var Controller[]
     */
    public array $controllers = [];
    /**
     * @var Struct[]
     */
    public array $structs = [];

    private function __construct () { }

    public static function getInstance (): Definition {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function parse (string $path) {
        self::getMapper()->mapJsonArray(json_decode(file_get_contents($path), true), $this);
    }

    public static function getMapper () {
        if (self::$mapper === null) {
            self::$mapper = new JsonMapper();
        }

        return self::$mapper;
    }
}