<?php


namespace Mainto\RpcServer\Util\ObjectMapper;


use Illuminate\Support\Str;
use Mainto\RpcServer\Util\Language;

class ArrayTypeParser {
    /**
     * @param string $doc
     * @param array $useClasses
     * @param string $namespace
     * @return array|string[]
     */
    public static function parseArrayProperty(string $doc, array $useClasses, string $namespace): array {
        if (!$doc) return ['array', null];

        foreach (explode("\n", $doc) as $line) {
            if (str_contains($line, '@var')) {
                $match = [];
                $type = null;
                if (preg_match('/.*@var\s*(.*)\[]/', $line, $match) && count($match) > 1) {
                    $type = $match[1];
                }
                $arrayDeepCount = 1;
                while ($type && Str::endsWith($type, '[]')) {
                    $type = substr($type, 0, -2);
                    $arrayDeepCount ++;
                }

                if (preg_match('/.*@var\s*array<(.*)>/', $line, $match) && count($match) > 1) {
                    $types = explode(',', $match[1]);
                    $type = array_pop($types);
                }

                if ($type !== null) {
                    if (in_array($type, Language::$simpleType)) {
                        return [$type.str_repeat('[]', $arrayDeepCount), $type];
                    }
                    if (isset($useClasses[$type])) {
                        return [$useClasses[$type].str_repeat('[]', $arrayDeepCount), $useClasses[$type]];
                    }

                    return [$namespace.'\\'.$type.str_repeat('[]', $arrayDeepCount), $namespace.'\\'.$type];
                }

                break;
            }
        }

        return ['array', null];
    }

    public static function parseArrayReturn (array $useClasses, string $doc, string $namespace): array {
        if (!$doc) return ['array', null];

        foreach (explode("\n", $doc) as $line) {
            if (str_contains($line, '@return')) {
                $match = [];
                $type = null;
                if (preg_match('/.*@return\s*(.*)\[]/', $line, $match) && count($match) > 1) {
                    $type = $match[1];
                }
                $arrayDeepCount = 1;
                while ($type && Str::endsWith($type, '[]')) {
                    $type = substr($type, 0, -2);
                    $arrayDeepCount ++;
                }

                if (preg_match('/.*@return\s*array<(.*)>/', $line, $match) && count($match) > 1) {
                    $types = explode(',', $match[1]);
                    $type = array_pop($types);
                }

                if ($type !== null) {
                    if (in_array($type, Language::$simpleType)) {
                        return [$type.str_repeat('[]', $arrayDeepCount), $type];
                    }
                    if (isset($useClasses[$type])) {
                        return [$useClasses[$type].str_repeat('[]', $arrayDeepCount), $useClasses[$type]];
                    }

                    return [$namespace.'\\'.$type.str_repeat('[]', $arrayDeepCount), $namespace.'\\'.$type];
                }

                break;
            }
        }

        return ['array', null];
    }
}