<?php


namespace Mainto\RpcServer\Util\ObjectMapper;


use ReflectionException;

/**
 * Class JsonMapper
 * @package Mainto\RpcServer\Util\ObjectMapper
 */
class JsonMapper implements MapperInterface {
    /**
     * @var array ['class_key' => ClassRef]
     */
    private static array $classRefMap = [];

    private static array $noConvType = [
        'bool',
        'int',
        'string',
        'float',
        'array',
    ];

    /**
     * @param $data
     * @param object $object
     */
    public static function map ($data, object $object) {
        if (is_string($data)) {
            $data = json_decode($data, true);
        }

        self::mapJsonArray($data, $object);
    }

    public static function mapJsonArray (array $data, object $object) {
        $classRef = self::classRef($object);

        foreach ($classRef->publicPropertyRefs as $propertyRef) {
            if (!array_key_exists($propertyRef->property->name, $data)) {
                continue;
            }

            $type = $propertyRef->type;
            if (in_array($type, self::$noConvType)) {
                $value = $data[$propertyRef->property->name];
            } else {
                if (ends_with($type, '[]')) {
                    $arrayValue = [];
                    $subType = substr($type, 0, -2);
                    foreach ($data[$propertyRef->property->name] as $datum) {
                        $subObject = new $subType;
                        self::mapJsonArray($datum, $subObject);
                        $arrayValue[] = $subObject;
                    }

                    $value = $arrayValue;
                } else {
                    $propertyObject = new $type;
                    self::mapJsonArray($data[$propertyRef->property->name], $propertyObject);

                    $value = $propertyObject;
                }
            }

            if ($propertyRef->setMethod) {
                $object->{$propertyRef->setMethod}($value);
            } else {
                $object->{$propertyRef->property->name} = $value;
            }
        }
    }

    /**
     * @param object $object
     * @return ClassRef
     * @throws ReflectionException
     */
    public static function classRef (object $object): ClassRef {
        $propertiesKey = get_class($object);
        if (isset(self::$classRefMap[$propertiesKey])) {
            return self::$classRefMap[$propertiesKey];
        } else {
            return self::$classRefMap[$propertiesKey] = new ClassRef($object);
        }
    }
}