<?php


namespace Mainto\RpcServer\RpcServer\ContextTrait;


use Mainto\RpcServer\Exceptions\RpcMethodNotFoundException;
use Mainto\RpcServer\Protocol\Common\Types\BodyType;
use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\RpcServer\Definition\Controller;
use Mainto\RpcServer\RpcServer\Definition\Method;
use Mainto\RpcServer\RpcServer\RpcRouter;

trait RequestTrait {
    /**
     * @var Request
     */
    private Request $request;

    /**
     * @return Request
     */
    public function getRequest (): Request {
        return $this->request;
    }

    public function isRawMode(): bool {
        return optional($this->request->getBody())->getBodyType() == BodyType::RAW;
    }

    public function getController (): Controller {
        $fullClassName = $this->request->getCallClassName();

        $controller = RpcRouter::getInstance()->getController($fullClassName);
        if (!$controller) {
            throw new RpcMethodNotFoundException(sprintf("%s::%s", $fullClassName, $this->request->getCallMethodName()));
        }

        return $controller;
    }

    public function getMethod (): Method {
        $fullClassName = $this->request->getCallClassName();

        $method = RpcRouter::getInstance()->getControllerMethod($fullClassName, $this->request->getCallMethodName());

        if (!$method) {
            throw new RpcMethodNotFoundException(sprintf("%s::%s", $fullClassName, $this->request->getCallMethodName()));
        }

        return $method;
    }
}